import React from "react";
import type { DOMAttributes } from "react";
import type { InteractiveCanvasAppState } from "../../types";
import type { RenderInteractiveSceneCallback } from "../../scene/types";
import type { NonDeletedExcalidrawElement } from "../../element/types";
type InteractiveCanvasProps = {
    containerRef: React.RefObject<HTMLDivElement>;
    canvas: HTMLCanvasElement | null;
    elements: readonly NonDeletedExcalidrawElement[];
    visibleElements: readonly NonDeletedExcalidrawElement[];
    selectedElements: readonly NonDeletedExcalidrawElement[];
    versionNonce: number | undefined;
    selectionNonce: number | undefined;
    scale: number;
    appState: InteractiveCanvasAppState;
    renderInteractiveSceneCallback: (data: RenderInteractiveSceneCallback) => void;
    handleCanvasRef: (canvas: HTMLCanvasElement | null) => void;
    onContextMenu: Exclude<DOMAttributes<HTMLCanvasElement | HTMLDivElement>["onContextMenu"], undefined>;
    onPointerMove: Exclude<DOMAttributes<HTMLCanvasElement>["onPointerMove"], undefined>;
    onPointerUp: Exclude<DOMAttributes<HTMLCanvasElement>["onPointerUp"], undefined>;
    onPointerCancel: Exclude<DOMAttributes<HTMLCanvasElement>["onPointerCancel"], undefined>;
    onTouchMove: Exclude<DOMAttributes<HTMLCanvasElement>["onTouchMove"], undefined>;
    onPointerDown: Exclude<DOMAttributes<HTMLCanvasElement>["onPointerDown"], undefined>;
    onDoubleClick: Exclude<DOMAttributes<HTMLCanvasElement>["onDoubleClick"], undefined>;
};
declare const _default: React.MemoExoticComponent<(props: InteractiveCanvasProps) => JSX.Element>;
export default _default;
